/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.deployer;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorInstance;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerRenderer;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class DeployerActorInstance
extends ActorInstance {
    private final class_4587 stack = new class_4587();
    class_2350 facing;
    boolean stationaryTimer;
    float yRot;
    float xRot;
    float zRot;
    ModelData pole;
    ModelData hand;
    RotatingData shaft;

    public DeployerActorInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        super(materialManager, simulationWorld, context);
        Material mat = materialManager.defaultSolid().material(Materials.TRANSFORMED);
        class_2680 state = context.state;
        DeployerBlockEntity.Mode mode = NBTHelper.readEnum(context.blockEntityData, "Mode", DeployerBlockEntity.Mode.class);
        PartialModel handPose = DeployerRenderer.getHandPose(mode);
        this.stationaryTimer = context.data.method_10545("StationaryTimer");
        this.facing = (class_2350)state.method_11654((class_2769)DirectionalKineticBlock.FACING);
        boolean rotatePole = (Boolean)state.method_11654((class_2769)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ this.facing.method_10166() == class_2350.class_2351.field_11051;
        this.yRot = AngleHelper.horizontalAngle(this.facing);
        this.xRot = this.facing == class_2350.field_11036 ? 270.0f : (this.facing == class_2350.field_11033 ? 90.0f : 0.0f);
        this.zRot = rotatePole ? 90.0f : 0.0f;
        this.pole = (ModelData)mat.getModel(AllPartialModels.DEPLOYER_POLE, state).createInstance();
        this.hand = (ModelData)mat.getModel(handPose, state).createInstance();
        class_2350.class_2351 axis = ((IRotate)state.method_26204()).getRotationAxis(state);
        this.shaft = (RotatingData)materialManager.defaultSolid().material(AllMaterialSpecs.ROTATING).getModel(KineticBlockEntityInstance.shaft(axis)).createInstance();
        int blockLight = this.localBlockLight();
        this.shaft.setRotationAxis(axis).setPosition(context.localPos).setBlockLight(blockLight);
        this.pole.setBlockLight(blockLight);
        this.hand.setBlockLight(blockLight);
    }

    @Override
    public void beginFrame() {
        double factor;
        if (this.context.disabled) {
            factor = 0.0;
        } else if (this.context.contraption.stalled || this.context.position == null || this.context.data.method_10545("StationaryTimer")) {
            factor = class_3532.method_15374((float)(AnimationTickHolder.getRenderTime() * 0.5f)) * 0.25f + 0.25f;
        } else {
            class_243 center = VecHelper.getCenterOf((class_2382)class_2338.method_49638((class_2374)this.context.position));
            double distance = this.context.position.method_1022(center);
            double nextDistance = this.context.position.method_1019(this.context.motion).method_1022(center);
            factor = 0.5 - class_3532.method_15350((double)class_3532.method_16436((double)AnimationTickHolder.getPartialTicks(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        class_243 offset = class_243.method_24954((class_2382)this.facing.method_10163()).method_1021(factor);
        TransformStack tstack = TransformStack.cast((class_4587)this.stack);
        this.stack.method_34426();
        ((TransformStack)tstack.translate((class_2382)this.context.localPos)).translate(offset);
        DeployerActorInstance.transformModel(this.stack, this.pole, this.hand, this.yRot, this.xRot, this.zRot);
    }

    static void transformModel(class_4587 stack, ModelData pole, ModelData hand, float yRot, float xRot, float zRot) {
        TransformStack tstack = TransformStack.cast((class_4587)stack);
        tstack.centre();
        tstack.rotate(class_2350.field_11036, (float)((double)(yRot / 180.0f) * Math.PI));
        tstack.rotate(class_2350.field_11034, (float)((double)(xRot / 180.0f) * Math.PI));
        stack.method_22903();
        tstack.rotate(class_2350.field_11035, (float)((double)(zRot / 180.0f) * Math.PI));
        tstack.unCentre();
        pole.setTransform(stack);
        stack.method_22909();
        tstack.unCentre();
        hand.setTransform(stack);
    }
}

